﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;
using Newtonsoft.Json;

namespace DeXGets
{

    public class BaseLookups : BaseClass
    {
        public Guid ExternalID;
        public string Type;
        public string Description;
        private string Service;
        private string Table;
        /// <summary>
        /// This sets up the service and the lookup type
        /// </summary>
        /// <param name="service"></param>
        /// <param name="table"></param>
        public void SetLookUp(string service, string table)
        {
            Service = service;
            Table = table;
        }
        protected string URL 
        { 
            get 
            {
                string call = string.Format("LearnerLookups?$filter=LookupType eq '{0}'&$select=ExternalID,LookupType,Description",Table);
                return SetURL(Service, call);         
            } 
        }
        public Dictionary<Guid,BaseLookups> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, BaseLookups> values = new Dictionary<Guid, BaseLookups>() ;
            
            string resp = DoCall(URL, token, httpClient, key);
            ODataResponse<BaseLookups> lookups = null;
            try
            {
                lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<BaseLookups>>(resp);
                foreach (BaseLookups s in lookups.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very unlikely  > 1000
                while (!string.IsNullOrEmpty(lookups.NextLink))
                {
                    resp = DoCall(GetNextLink(lookups.NextLink), token, httpClient, key);
                    lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<BaseLookups>>(resp);
                    foreach (BaseLookups s in lookups.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}